# R Code Dissolution USP <711> Heat Map
# January 2017
# Lori B. Pfahler (lori.pfahler@merck.com)
# 
# Programmed using the following R Version:
# R version 3.3.2 (2016-10-31) -- "Sincere Pumpkin Patch"
# Copyright (C) 2016 The R Foundation for Statistical Computing
# Platform: x86_64-w64-mingw32/x64 (64-bit)

# Run dissolution simulation for a range of standard deviations and 
# means to create a heatmap used in book.
# Requires simDissoTest function in file:
# "USP 711 Simulation R Code.R"

# Run UDU simulation for a range of standard deviations and 
# mean distance from Q to create a heatmap

for (i in seq(0.1, 12, 0.1))
{
  for(j in seq(-1, 10, 0.5))
  { 
    runA <- simDissoTest(reps=10000, mean=80+j, sd=i, Q=80)
    if (i==0.1&j==-1)
      DissoResults <- c(j,i,mean(runA$PassAll))
    else
    {
      currentResults <- c(j,i,mean(runA$PassAll))
      DissoResults <- rbind(DissoResults, currentResults)
    }
  }
}
colnames(DissoResults) <- c("Mean-Q", "SD", "Pass")
DissoResults <- data.frame(DissoResults, row.names=NULL)

# graphics device for better copy/paste
windows(width=9, height=7)

# Heatmap of UDU Test
# rows are standard deviations and columns are means
DissoResults.mat <- matrix(DissoResults[,3], nrow=23, ncol=120)
x <- seq(-1, 10, 0.5)
y <-seq(0.1, 12, 0.1)
filled.contour(x, y, DissoResults.mat, levels=c(0, 0.8, 0.9, 0.95, 0.99,1), ylim=c(0.1,12),
               col=c("red", "orange", "yellow", "light green", "green"), 
               ylab="Standard Deviation (within Batch)",
               xlab="Mean - Q (% of Label Claim)",
               main="Probability of Passing Dissolution Test",
               plot.axes={axis(2, at=c(seq(1, 12, 1)), las=2); 
                 abline(h=c(seq(1, 11, 1)),col="white",lty=2, lwd=1); 
                 axis(1, at=c(seq(-1, 10, 1)), las=2); abline(v=c(seq(0,9,1)), col="white", lty=2, lwd=1)},
               key.axes=axis(4, at=c(0.80, 0.90, 0.95, 0.99)))


